% Model of an isothermal batch reactor - Alkylation

% Function file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

function dcdt = f(t,c,cC40,ciC40,k1,K,V,m)

dcdt = zeros(1,1);     % Allocate space for the right-hand sides of the DEs

cC4 = c(1);                  % Butene concentration
ciC4 = ciC40 - cC40 + cC4;   % Isobutane concentration (from stoichiometry)
r = k1*cC4/(1 + K*cC4/ciC4); % Reaction rate

dcdt(1) = -m*r/V;            % Differential equation
